package org.nhindirect.gateway.smtp.james.mailet;


import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class is used to interface with the auto reply tables to see which recipients need to send auto replies to the sender
 */

/**
 *
 * @author Elan Jaffee
 */
public class AutoReply {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(
            AutoReply.class);
    protected String sender = null;  //sender of the original message
    protected HashMap<Integer,String> mailboxtomessage = new HashMap<Integer,String>();  //map of recipient mailboxes to message
    
    /*
     * @param maiboxes  mailbox ids of all local recipients
     * @oaram sender    sender of the original message
     */
    public AutoReply(Collection<Integer> mailboxes, String sender){
        this.sender = sender.toLowerCase();
        Connection conn = null;
        try {
            try {
                conn = databaseConnect();
            } catch (SQLException e) {
                LOGGER.trace("Failed to connect to SQL Server");
            }
            PreparedStatement prepQuery = null;
            if (conn != null) {
                try {
                    //get all auto responses where there does not exist an autoreply for the the sender address 
                    String sqlQuery = "select [id] , [mailbox_id], [content] from automatic_replies as ar where (mailbox_id in (" + (StringUtils.repeat("?,", mailboxes.size()));
                    sqlQuery = sqlQuery.substring(0, sqlQuery.length() - 1) + ") and (start_at is null or start_at <= ?) and (end_at is null or end_at >=  ?) and  id not in ( select automatic_reply_id from automatic_reply_log as arl where email_address = ? and arl.sent_at > ar.updated_at))";
                    prepQuery = conn.prepareStatement(sqlQuery);
                    Iterator<Integer> mailboxIter = mailboxes.iterator();
                    int c = 1;
                    while (mailboxIter.hasNext()) {//add each mail box for the recipietns so you can get all the messages at once.
                        prepQuery.setString(c++, ""+mailboxIter.next());
                    }
                    prepQuery.setString(c++, ""+System.currentTimeMillis() / 1000L);//start date
                    prepQuery.setString(c++, ""+System.currentTimeMillis() / 1000L);//end date
                    prepQuery.setString(c++, sender);//sender use to find if enty exists
                    // try to execute query
                    ResultSet rs = null;
                    try {
                        rs = prepQuery.executeQuery();
                        while (rs.next()) {
                            //stores the relation between mailbox_id and the content of the message
                            mailboxtomessage.put(rs.getInt("mailbox_id"),rs.getString("content"));
                        }
                        rs.close();
                    } finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                } finally {
                    if (prepQuery != null) {
                        prepQuery.close();
                    }
                }
            }
        } catch (SQLException e) {
            LOGGER.debug("SQL Exception for bad query statement in AutoReply.");
        } finally {
            if (conn != null) {
                try {
                    conn.close();
                } catch (SQLException e) {
                    LOGGER.debug("Failed to close connection");
                }

            }
        }
    }
    /*
     * Get the content of the message based on the id
     * @param mailbox_id    id of the mailbox that you are looking for the auto reply
     * @return                 auto reply message from mailbox
     */
    public String getMessage(Integer mailbox_id){
        return mailboxtomessage.get(mailbox_id);
    }
    /*
     * This function adds and address and automatic_reply_id to the automatic_reply_log so that it knows when an auto reply was sent
     */
    public void messageSent(int mailbox_id){
        Connection conn = null;
        try {
            try {
                conn = databaseConnect();
            } catch (SQLException e) {
                LOGGER.trace("Failed to connect to SQL Server");
            }
            PreparedStatement prepQuery = null;
            //int output;
            if (conn != null) {
                try {
                    //this query inserts and enty into the automatic_reply_log and gets the id of the automatic_reply using the messge id
                    String sqlQuery = "insert into automatic_reply_log (automatic_reply_id, email_address, sent_at) select  id, ?, ? from automatic_replies where mailbox_id = ?";
                    prepQuery = conn.prepareStatement(sqlQuery);
                    prepQuery.setString(1, sender);
                    prepQuery.setLong(2, System.currentTimeMillis() / 1000L);
                    prepQuery.setInt(3, mailbox_id);
                    //output = prepQuery.executeUpdate();
                   prepQuery.executeUpdate();
                   
                }finally {
                    if (prepQuery != null) {
                        prepQuery.close();
                    }
                }
            }
            
            } catch (SQLException e) {
            LOGGER.debug("SQL Exception for bad query statement in users exists function.");
        } finally {
            if (conn != null) {
                try {
                    conn.close();
                } catch (SQLException e) {
                    LOGGER.debug("Failed to close connection");
                }

            }
        }
    }
    /*
     * This function connect to the mail database
     */
    private static Connection databaseConnect() throws SQLException {
        Connection conn;
        Map<String, String> propertiesMap = MailetProperties.getPropertiesList();
            String db_hostname = propertiesMap.get("mailet.db.hostname");
            String db_port = propertiesMap.get("mailet.db.port");
            String db_name = propertiesMap.get("mailet.db.mailname");
            String db_instance = propertiesMap.get("mailet.db.instance");
            String db_userid = propertiesMap.get("mailet.db.mailusername");
            String db_prd = propertiesMap
                    .get("mailet.db.mailpassword");
        String db_connect_string = "jdbc:sqlserver://" + db_hostname + ":"
                + db_port + ";databaseName=" + db_name
                + ";ssl=require;hostNameInCertificate=" + db_hostname
                + ";instanceName=" + db_instance + ";portNumber=" + db_port
                + ";trustServerCertificate=true";

        // Load DB Driver
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        } catch (ClassNotFoundException f) {
            LOGGER.trace("Could not load SQL Server DB driver");
        }

        // Connect to DB
        try {
            conn = DriverManager.getConnection(db_connect_string, db_userid,
                    db_prd);
        } catch (SQLException sqlException) {
            LOGGER.trace("SQL Server database not reachable");
            return null;
        }

        return conn;
    }
}
